<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('S.N.'); ?></th>
                                    <th><?php echo app('translator')->get('FDR No.'); ?> | <?php echo app('translator')->get('Plan'); ?></th>
                                    <th><?php echo app('translator')->get('User'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?></th>
                                    <th><?php echo app('translator')->get('Profit'); ?></th>
                                    <th><?php echo app('translator')->get('Created'); ?> | <?php echo app('translator')->get('Next Installment'); ?></th>
                                    <th><?php echo app('translator')->get('Lock-In Period'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <?php if(can('admin.fdr.due.pay') || can('admin.fdr.installments')): ?>
                                        <th><?php echo app('translator')->get('Action'); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fdr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($loop->index + $data->firstItem()); ?></td>

                                        <td>
                                            <span class="fw-bold"><?php echo e(__($fdr->fdr_number)); ?></span>
                                            <span class="d-block text-muted"><?php echo e(__(@$fdr->plan->name)); ?></span>
                                        </td>

                                        <td>
                                            <span class="fw-bold d-block"><?php echo e(__(@$fdr->user->fullname)); ?></span>
                                            <?php if($fdr->user): ?>
                                                <span class="small">
                                                    <?php $hasPermission = App\Models\Role::hasPermission('admin.users.detail')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                                        <a href="<?php echo e(route('admin.users.detail', $fdr->user_id)); ?>"><span>@</span><?php echo e($fdr->user->username); ?></a>
                                                    <?php else: ?>
                                                        <span>@</span><?php echo e($fdr->user->username); ?>

                                                    <?php endif ?>
                                                </span>
                                            <?php endif; ?>
                                        </td>

                                        <td>
                                            <span><?php echo e($general->cur_sym . showAmount($fdr->amount)); ?></span>
                                            <span class="d-block text-muted"><?php echo app('translator')->get('Profit'); ?>
                                                <?php echo e(getAmount($fdr->interest_rate)); ?>% </span>
                                        </td>

                                        <td>
                                            <span><?php echo e($general->cur_sym . showAmount($fdr->per_installment)); ?></span>
                                            <span class="text-muted d-block"><?php echo app('translator')->get('Per'); ?>
                                                <?php echo e($fdr->installment_interval); ?> <?php echo app('translator')->get('Days'); ?></span>
                                        </td>

                                        <td>
                                            <span class="d-block">
                                                <?php echo e(showDateTime($fdr->created_at, 'd M, Y')); ?>

                                            </span>
                                            <?php if($fdr->status != 2): ?>
                                                <span class="text--info"><?php echo e(showDateTime($fdr->next_installment_date, 'd M, Y')); ?></span>
                                            <?php else: ?>
                                                <?php echo app('translator')->get('N/A'); ?>
                                            <?php endif; ?>

                                        </td>

                                        <td>
                                            <span> <?php echo e(showDateTime($fdr->locked_date, 'd M, Y')); ?> </span>
                                            <span class="d-block text-muted"><?php echo e(diffForHumans($fdr->locked_date, 'd M, Y')); ?></span>
                                        </td>

                                        <td><?php echo $fdr->statusBadge; ?></td>

                                        <?php if(can('admin.fdr.due.pay') || can('admin.fdr.installments')): ?>
                                            <td>
                                                <div class="button--group">
                                                    <?php if($fdr->next_installment_date < today()): ?>
                                                        <?php $hasPermission = App\Models\Role::hasPermission('admin.fdr.due.pay')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                                            <button class="btn btn-sm btn-outline--warning paymentBtn" data-per_installment="<?php echo e($general->cur_sym . $fdr->per_installment); ?>" data-installments="<?php echo e($fdr->dueInstallment()); ?>"
                                                                data-amount="<?php echo e($general->cur_sym . showAmount($fdr->dueAmount())); ?>" data-action="<?php echo e(route('admin.fdr.due.pay', $fdr->id)); ?>"><?php echo app('translator')->get('Pay Due'); ?></button>
                                                        <?php endif ?>
                                                    <?php endif; ?>

                                                    <?php $hasPermission = App\Models\Role::hasPermission('admin.fdr.installments')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                                        <a class="btn btn-sm btn-outline--primary" href="<?php echo e(route('admin.fdr.installments', $fdr->id)); ?>">
                                                            <i class="las la-history"></i>
                                                            <?php echo app('translator')->get('Installments'); ?>
                                                        </a>
                                                    <?php endif ?>
                                                </div>
                                            </td>
                                        <?php endif; ?>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($data->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($data)); ?>

                    </div>
                <?php endif; ?>
            </div><!-- card end -->
        </div>
    </div>

    <div class="modal fade" id="paymentModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel"><?php echo app('translator')->get('Pay Due Installments'); ?></h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <form action="" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item d-flex justify-content-between flex-wrap">
                                <span><?php echo app('translator')->get('Delayed Installments'); ?></span>
                                <span class="delayed-installments"></span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between flex-wrap">
                                <span><?php echo app('translator')->get('Per Installment'); ?></span>
                                <span class="per-installment"></span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between flex-wrap">
                                <span><?php echo app('translator')->get('Total Amount'); ?></span>
                                <span class="installment-amount"></span>
                            </li>
                        </ul>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--dark btn-sm" data-bs-dismiss="modal" type="button"><?php echo app('translator')->get('Cancel'); ?></button>
                        <button class="btn btn--primary btn-sm" type="submit"><?php echo app('translator')->get('Pay All'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['dateSearch' => 'yes']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['dateSearch' => 'yes']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.paymentBtn').on('click', function() {
                let modal = $('#paymentModal');
                let data = $(this).data();
                let form = modal.find('form')[0];
                form.action = data.action;
                modal.find('.delayed-installments').text(data.installments);
                modal.find('.per-installment').text(data.per_installment);
                modal.find('.installment-amount').text(data.amount);
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yektech/public_html/roam.yektech.com.ng/core/resources/views/admin/fdr/index.blade.php ENDPATH**/ ?>