<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        \App\Setting::insert([
            [
                'key'=>'general_site_name',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'regis_enable_registration',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'general_homepage_title',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'general_homepage_meta_desc',
                'type'=>'textarea',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'general_admin_email',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'color_navbar',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'color_primary_color',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'color_navtext',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'color_footer',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'color_footertext',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'image_logo',
                'type'=>'hidden',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'regis_registration_instructions',
                'type'=>'textarea',
                'options'=>'',
                'class'=>'rte',
            ],
            [
                'key'=>'footer_about',
                'type'=>'textarea',
                'options'=>'',
                'class'=>'rte',
            ],
            [
                'key'=>'footer_address',
                'type'=>'textarea',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'footer_email',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'footer_tel',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'image_icon',
                'type'=>'hidden',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'country_id',
                'type'=>'select',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'general_auto_enroll',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'general_ssl',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'footer_newsletter_code',
                'type'=>'textarea',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'footer_credits',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'general_header_scripts',
                'type'=>'textarea',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'general_foot_scripts',
                'type'=>'textarea',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'menu_show_courses',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'menu_show_sessions',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'menu_show_blog',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'menu_show_contact',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'menu_show_articles',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'footer_show_sicons',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'footer_show_newsletter',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'footer_show_about',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'footer_show_contact',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'regis_email_message',
                'type'=>'textarea',
                'options'=>'',
                'class'=>'rte',
            ],
            [
                'key'=>'color_page_title',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'color_page_title_text',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'regis_enrollment_alert',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'regis_signup_alert',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'general_disqus',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_enroll',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_discussion',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_classes_attended',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_revision_notes',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_take_test',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_classes',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_sessions',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_blog',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_contact_us',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_about_us',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_follow_us',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'general_discussion_instructions',
                'type'=>'textarea',
                'options'=>'',
                'class'=>'rte',
            ],
            [
                'key'=>'mail_protocol',
                'type'=>'select',
                'options'=>'mail=Mail,smtp=SMTP',
                'class'=>'',
            ],
            [
                'key'=>'mail_smtp_host',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'mail_smtp_username',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'mail_smtp_password',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'mail_smtp_port',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'mail_smtp_timeout',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'general_show_fee',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'menu_show_discussions',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'menu_show_tests',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'menu_show_notes',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'menu_show_attended',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'general_site_ip',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'general_send_reminder',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'general_reminder_days',
                'type'=>'text',
                'options'=>'',
                'class'=>'number',
            ],
            [
                'key'=>'general_timezone',
                'type'=>'select',
                'options'=>'Australia/Adelaide,Australia/Broken_Hill,Australia/Darwin,Australia/North,Australia/South,Australia/Yancowinna,America/Porto_Acre,Australia/Adelaide,America/Eirunepe,America/Rio_Branco,Brazil/Acre,Asia/Jayapura,Australia/Broken_Hill,Australia/Darwin,Australia/North,Australia/South,Australia/Yancowinna,America/Porto_Acre,America/Eirunepe,America/Rio_Branco,Brazil/Acre,Australia/Eucla,Australia/Eucla,America/Goose_Bay,America/Pangnirtung,America/Halifax,America/Barbados,America/Blanc-Sablon,America/Glace_Bay,America/Goose_Bay,America/Martinique,America/Moncton,America/Pangnirtung,America/Thule,Atlantic/Bermuda,Canada/Atlantic,Asia/Baghdad,Australia/Melbourne,Antarctica/Macquarie,Australia/ACT,Australia/Brisbane,Australia/Canberra,Australia/Currie,Australia/Hobart,Australia/Lindeman,Australia/NSW,Australia/Queensland,Australia/Sydney,Australia/Tasmania,Australia/Victoria,Australia/Melbourne,Antarctica/Macquarie,Australia/ACT,Australia/Brisbane,Australia/Canberra,Australia/Currie,Australia/Hobart,Australia/LHI,Australia/Lindeman,Australia/Lord_Howe,Australia/NSW,Australia/Queensland,Australia/Sydney,Australia/Tasmania,Australia/Victoria,Asia/Kabul,Asia/Kabul,America/Anchorage,America/Anchorage,America/Adak,America/Atka,America/Anchorage,America/Juneau,America/Nome,America/Sitka,America/Yakutat,America/Anchorage,America/Juneau,America/Nome,America/Sitka,America/Yakutat,Asia/Aqtobe,Asia/Aqtobe,Asia/Aqtobe,Asia/Aqtobe,Asia/Almaty,Asia/Almaty,Asia/Almaty,Asia/Yerevan,Asia/Yerevan,America/Boa_Vista,America/Campo_Grande,America/Cuiaba,America/Manaus,America/Porto_Velho,America/Santarem,Brazil/West,Asia/Yerevan,Asia/Yerevan,America/Asuncion,America/Boa_Vista,America/Campo_Grande,America/Cuiaba,America/Eirunepe,America/Manaus,America/Porto_Acre,America/Porto_Velho,America/Rio_Branco,America/Santarem,Brazil/Acre,Brazil/West,Europe/Amsterdam,Europe/Athens,Asia/Anadyr,Asia/Anadyr,Asia/Anadyr,Asia/Anadyr,Asia/Anadyr,Asia/Anadyr,America/Curacao,America/Aruba,America/Kralendijk,America/Lower_Princes,America/Halifax,America/Blanc-Sablon,America/Glace_Bay,America/Moncton,America/Pangnirtung,America/Puerto_Rico,Canada/Atlantic,Asia/Aqtau,Asia/Aqtau,Asia/Aqtobe,Asia/Aqtau,Asia/Aqtau,Asia/Aqtobe,America/Buenos_Aires,America/Buenos_Aires,America/Argentina/Buenos_Aires,America/Argentina/Catamarca,America/Argentina/ComodRivadavia,America/Argentina/Cordoba,America/Argentina/Jujuy,America/Argentina/La_Rioja,America/Argentina/Mendoza,America/Argentina/Rio_Gallegos,America/Argentina/Salta,America/Argentina/San_Juan,America/Argentina/San_Luis,America/Argentina/Tucuman,America/Argentina/Ushuaia,America/Catamarca,America/Cordoba,America/Jujuy,America/Mendoza,America/Rosario,Antarctica/Palmer,America/Argentina/Buenos_Aires,America/Argentina/Catamarca,America/Argentina/ComodRivadavia,America/Argentina/Cordoba,America/Argentina/Jujuy,America/Argentina/La_Rioja,America/Argentina/Mendoza,America/Argentina/Rio_Gallegos,America/Argentina/Salta,America/Argentina/San_Juan,America/Argentina/San_Luis,America/Argentina/Tucuman,America/Argentina/Ushuaia,America/Catamarca,America/Cordoba,America/Jujuy,America/Mendoza,America/Rosario,Antarctica/Palmer,America/Buenos_Aires,America/Buenos_Aires,America/Argentina/Buenos_Aires,America/Argentina/Catamarca,America/Argentina/ComodRivadavia,America/Argentina/Cordoba,America/Argentina/Jujuy,America/Argentina/La_Rioja,America/Argentina/Mendoza,America/Argentina/Rio_Gallegos,America/Argentina/Salta,America/Argentina/San_Juan,America/Argentina/San_Luis,America/Argentina/Tucuman,America/Argentina/Ushuaia,America/Catamarca,America/Cordoba,America/Jujuy,America/Mendoza,America/Rosario,Antarctica/Palmer,America/Argentina/Buenos_Aires,America/Argentina/Catamarca,America/Argentina/ComodRivadavia,America/Argentina/Cordoba,America/Argentina/Jujuy,America/Argentina/La_Rioja,America/Argentina/Mendoza,America/Argentina/Rio_Gallegos,America/Argentina/Salta,America/Argentina/San_Juan,America/Argentina/San_Luis,America/Argentina/Tucuman,America/Argentina/Ushuaia,America/Catamarca,America/Cordoba,America/Jujuy,America/Mendoza,America/Rosario,Antarctica/Palmer,Asia/Ashkhabad,Asia/Ashkhabad,Asia/Ashgabat,Asia/Ashgabat,Asia/Ashkhabad,Asia/Ashkhabad,Asia/Ashgabat,Asia/Ashgabat,Asia/Riyadh,America/Anguilla,America/Antigua,America/Aruba,America/Barbados,America/Blanc-Sablon,America/Curacao,America/Dominica,America/Glace_Bay,America/Goose_Bay,America/Grand_Turk,America/Grenada,America/Guadeloupe,America/Halifax,America/Kralendijk,America/Lower_Princes,America/Marigot,America/Martinique,America/Miquelon,America/Moncton,America/Montserrat,America/Pangnirtung,America/Port_of_Spain,America/Puerto_Rico,America/Santo_Domingo,America/St_Barthelemy,America/St_Kitts,America/St_Lucia,America/St_Thomas,America/St_Vincent,America/Thule,America/Tortola,America/Virgin,Atlantic/Bermuda,Canada/Atlantic,Asia/Aden,Asia/Baghdad,Asia/Bahrain,Asia/Kuwait,Asia/Qatar,Australia/Perth,Australia/West,Australia/Perth,Antarctica/Casey,Australia/West,America/Halifax,America/Blanc-Sablon,America/Glace_Bay,America/Moncton,America/Pangnirtung,America/Puerto_Rico,Canada/Atlantic,Atlantic/Azores,Atlantic/Azores,Atlantic/Azores,Atlantic/Azores,Atlantic/Azores,Asia/Baku,Asia/Baku,Asia/Baku,Asia/Baku,Asia/Baku,Asia/Baku,Asia/Baku,Asia/Baku,Europe/London,Asia/Dacca,Asia/Dhaka,Europe/Belfast,Europe/Gibraltar,Europe/Guernsey,Europe/Isle_of_Man,Europe/Jersey,GB,America/Adak,Asia/Dacca,America/Atka,America/Nome,Asia/Dhaka,Africa/Mogadishu,Africa/Addis_Ababa,Africa/Asmara,Africa/Asmera,Africa/Dar_es_Salaam,Africa/Djibouti,Africa/Kampala,Africa/Nairobi,Indian/Antananarivo,Indian/Comoro,Indian/Mayotte,Africa/Nairobi,Africa/Addis_Ababa,Africa/Asmara,Africa/Asmera,Africa/Dar_es_Salaam,Africa/Djibouti,Africa/Kampala,Africa/Mogadishu,Indian/Antananarivo,Indian/Comoro,Indian/Mayotte,America/Barbados,Europe/Tiraspol,America/Bogota,Asia/Baghdad,Asia/Bangkok,Asia/Phnom_Penh,Asia/Vientiane,Asia/Jakarta,Europe/Bucharest,Europe/Chisinau,Asia/Brunei,Asia/Brunei,Asia/Kuching,Asia/Kuching,Asia/Kuching,America/La_Paz,America/La_Paz,America/Sao_Paulo,America/Araguaina,America/Bahia,America/Belem,America/Fortaleza,America/Maceio,America/Recife,Brazil/East,America/Sao_Paulo,America/Araguaina,America/Bahia,America/Belem,America/Fortaleza,America/Maceio,America/Recife,America/Santarem,Brazil/East,Europe/London,Europe/London,America/Adak,America/Atka,America/Nome,Pacific/Midway,Pacific/Pago_Pago,Pacific/Samoa,Europe/Belfast,Europe/Guernsey,Europe/Isle_of_Man,Europe/Jersey,GB,Europe/Belfast,Europe/Dublin,Europe/Gibraltar,Europe/Guernsey,Europe/Isle_of_Man,Europe/Jersey,GB,Pacific/Bougainville,Asia/Thimbu,Asia/Thimphu,Asia/Kolkata,Asia/Calcutta,Asia/Dacca,Asia/Dhaka,Asia/Rangoon,Atlantic/Canary,America/Anchorage,Australia/Adelaide,Africa/Juba,Africa/Khartoum,Antarctica/Casey,America/Anchorage,Africa/Khartoum,Africa/Blantyre,Africa/Bujumbura,Africa/Gaborone,Africa/Harare,Africa/Juba,Africa/Kigali,Africa/Lubumbashi,Africa/Lusaka,Africa/Maputo,Africa/Windhoek,America/Anchorage,Indian/Cocos,America/Rankin_Inlet,America/Resolute,America/Chicago,Asia/Shanghai,America/Havana,America/Atikokan,America/Bahia_Banderas,America/Belize,America/Cambridge_Bay,America/Cancun,America/Chihuahua,America/Coral_Harbour,America/Costa_Rica,America/El_Salvador,America/Fort_Wayne,America/Guatemala,America/Indiana/Indianapolis,America/Indiana/Knox,America/Indiana/Marengo,America/Indiana/Petersburg,America/Indiana/Tell_City,America/Indiana/Vevay,America/Indiana/Vincennes,America/Indiana/Winamac,America/Indianapolis,America/Iqaluit,America/Kentucky/Louisville,America/Kentucky/Monticello,America/Knox_IN,America/Louisville,America/Managua,America/Matamoros,America/Menominee,America/Merida,America/Mexico_City,America/Monterrey,America/North_Dakota/Beulah,America/North_Dakota/Center,America/North_Dakota/New_Salem,America/Ojinaga,America/Pangnirtung,America/Rainy_River,America/Rankin_Inlet,America/Resolute,America/Tegucigalpa,America/Winnipeg,Canada/Central,Mexico/General,Asia/Chongqing,Asia/Chungking,Asia/Harbin,Asia/Taipei,PRC,ROC,Europe/Berlin,Europe/Berlin,Europe/Kaliningrad,Africa/Algiers,Africa/Ceuta,Africa/Tripoli,Africa/Tunis,Antarctica/Troll,Arctic/Longyearbyen,Atlantic/Jan_Mayen,Europe/Amsterdam,Europe/Andorra,Europe/Athens,Europe/Belgrade,Europe/Bratislava,Europe/Brussels,Europe/Budapest,Europe/Busingen,Europe/Chisinau,Europe/Copenhagen,Europe/Gibraltar,Europe/Kaliningrad,Europe/Kiev,Europe/Lisbon,Europe/Ljubljana,Europe/Luxembourg,Europe/Madrid,Europe/Malta,Europe/Minsk,Europe/Monaco,Europe/Oslo,Europe/Paris,Europe/Podgorica,Europe/Prague,Europe/Riga,Europe/Rome,Europe/San_Marino,Europe/Sarajevo,Europe/Simferopol,Europe/Skopje,Europe/Sofia,Europe/Stockholm,Europe/Tallinn,Europe/Tirane,Europe/Tiraspol,Europe/Uzhgorod,Europe/Vaduz,Europe/Vatican,Europe/Vienna,Europe/Vilnius,Europe/Warsaw,Europe/Zagreb,Europe/Zaporozhye,Europe/Zurich,Europe/Berlin,Europe/Kaliningrad,Africa/Algiers,Africa/Casablanca,Africa/Ceuta,Africa/Tripoli,Africa/Tunis,Arctic/Longyearbyen,Atlantic/Jan_Mayen,Europe/Amsterdam,Europe/Andorra,Europe/Athens,Europe/Belgrade,Europe/Bratislava,Europe/Brussels,Europe/Budapest,Europe/Busingen,Europe/Chisinau,Europe/Copenhagen,Europe/Gibraltar,Europe/Kaliningrad,Europe/Kiev,Europe/Lisbon,Europe/Ljubljana,Europe/Luxembourg,Europe/Madrid,Europe/Malta,Europe/Minsk,Europe/Monaco,Europe/Oslo,Europe/Paris,Europe/Podgorica,Europe/Prague,Europe/Riga,Europe/Rome,Europe/San_Marino,Europe/Sarajevo,Europe/Simferopol,Europe/Skopje,Europe/Sofia,Europe/Stockholm,Europe/Tallinn,Europe/Tirane,Europe/Tiraspol,Europe/Uzhgorod,Europe/Vaduz,Europe/Vatican,Europe/Vienna,Europe/Vilnius,Europe/Warsaw,Europe/Zagreb,Europe/Zaporozhye,Europe/Zurich,America/Scoresbysund,America/Scoresbysund,Pacific/Chatham,Pacific/Chatham,Pacific/Chatham,America/Belize,Asia/Choibalsan,Asia/Choibalsan,Asia/Choibalsan,Asia/Choibalsan,Pacific/Chuuk,Pacific/Truk,Pacific/Yap,Pacific/Rarotonga,Pacific/Rarotonga,Pacific/Rarotonga,America/Santiago,America/Santiago,Antarctica/Palmer,Chile/Continental,Chile/Continental,America/Santiago,America/Santiago,America/Santiago,Antarctica/Palmer,Chile/Continental,Antarctica/Palmer,Chile/Continental,Chile/Continental,America/Argentina/Buenos_Aires,America/Argentina/Catamarca,America/Argentina/ComodRivadavia,America/Argentina/Cordoba,America/Argentina/Jujuy,America/Argentina/La_Rioja,America/Argentina/Mendoza,America/Argentina/Rio_Gallegos,America/Argentina/Salta,America/Argentina/San_Juan,America/Argentina/San_Luis,America/Argentina/Tucuman,America/Argentina/Ushuaia,America/Buenos_Aires,America/Catamarca,America/Cordoba,America/Jujuy,America/Mendoza,America/Rosario,America/Caracas,America/La_Paz,America/Cayman,America/Panama,Europe/Chisinau,Europe/Tiraspol,America/Bogota,America/Bogota,America/Chicago,America/Atikokan,America/Coral_Harbour,America/Fort_Wayne,America/Indiana/Indianapolis,America/Indiana/Knox,America/Indiana/Marengo,America/Indiana/Petersburg,America/Indiana/Tell_City,America/Indiana/Vevay,America/Indiana/Vincennes,America/Indiana/Winamac,America/Indianapolis,America/Kentucky/Louisville,America/Kentucky/Monticello,America/Knox_IN,America/Louisville,America/Menominee,America/Rainy_River,America/Winnipeg,Canada/Central,America/Chicago,America/Havana,America/Atikokan,America/Bahia_Banderas,America/Belize,America/Cambridge_Bay,America/Cancun,America/Chihuahua,America/Coral_Harbour,America/Costa_Rica,America/Detroit,America/El_Salvador,America/Fort_Wayne,America/Guatemala,America/Hermosillo,America/Indiana/Indianapolis,America/Indiana/Knox,America/Indiana/Marengo,America/Indiana/Petersburg,America/Indiana/Tell_City,America/Indiana/Vevay,America/Indiana/Vincennes,America/Indiana/Winamac,America/Indianapolis,America/Iqaluit,America/Kentucky/Louisville,America/Kentucky/Monticello,America/Knox_IN,America/Louisville,America/Managua,America/Matamoros,America/Mazatlan,America/Menominee,America/Merida,America/Mexico_City,America/Monterrey,America/North_Dakota/Beulah,America/North_Dakota/Center,America/North_Dakota/New_Salem,America/Ojinaga,America/Pangnirtung,America/Rainy_River,America/Rankin_Inlet,America/Regina,America/Resolute,America/Swift_Current,America/Tegucigalpa,America/Thunder_Bay,America/Winnipeg,Canada/Central,Canada/East-Saskatchewan,Canada/Saskatchewan,Mexico/BajaSur,Mexico/General,Asia/Chongqing,Asia/Chungking,Asia/Harbin,Asia/Macao,Asia/Macau,Asia/Shanghai,Asia/Taipei,PRC,ROC,Europe/Zaporozhye,Atlantic/Cape_Verde,Atlantic/Cape_Verde,Atlantic/Cape_Verde,America/Chicago,America/Atikokan,America/Coral_Harbour,America/Fort_Wayne,America/Indiana/Indianapolis,America/Indiana/Knox,America/Indiana/Marengo,America/Indiana/Petersburg,America/Indiana/Tell_City,America/Indiana/Vevay,America/Indiana/Vincennes,America/Indiana/Winamac,America/Indianapolis,America/Kentucky/Louisville,America/Kentucky/Monticello,America/Knox_IN,America/Louisville,America/Menominee,America/Mexico_City,America/Rainy_River,America/Winnipeg,Canada/Central,Mexico/General,Indian/Christmas,Pacific/Guam,Pacific/Saipan,Asia/Dacca,Asia/Dhaka,Antarctica/Davis,Antarctica/Davis,Antarctica/DumontDUrville,Europe/Dublin,Asia/Dushanbe,Asia/Dushanbe,Asia/Dushanbe,Asia/Dushanbe,Chile/EasterIsland,Chile/EasterIsland,Pacific/Easter,Pacific/Easter,Chile/EasterIsland,Chile/EasterIsland,Chile/EasterIsland,Pacific/Easter,Pacific/Easter,Pacific/Easter,Africa/Khartoum,Africa/Addis_Ababa,Africa/Asmara,Africa/Asmera,Africa/Dar_es_Salaam,Africa/Djibouti,Africa/Juba,Africa/Kampala,Africa/Mogadishu,Africa/Nairobi,Indian/Antananarivo,Indian/Comoro,Indian/Mayotte,America/Guayaquil,Pacific/Galapagos,America/Iqaluit,America/New_York,America/Cancun,America/Detroit,America/Fort_Wayne,America/Grand_Turk,America/Indiana/Indianapolis,America/Indiana/Marengo,America/Indiana/Petersburg,America/Indiana/Tell_City,America/Indiana/Vevay,America/Indiana/Vincennes,America/Indiana/Winamac,America/Indianapolis,America/Iqaluit,America/Jamaica,America/Kentucky/Louisville,America/Kentucky/Monticello,America/Louisville,America/Montreal,America/Nassau,America/Nipigon,America/Pangnirtung,America/Port-au-Prince,America/Santo_Domingo,America/Thunder_Bay,America/Toronto,Canada/Eastern,Europe/Helsinki,Africa/Cairo,Asia/Amman,Asia/Beirut,Asia/Damascus,Asia/Gaza,Asia/Hebron,Asia/Istanbul,Asia/Nicosia,Europe/Athens,Europe/Bucharest,Europe/Chisinau,Europe/Istanbul,Europe/Kaliningrad,Europe/Kiev,Europe/Mariehamn,Europe/Minsk,Europe/Moscow,Europe/Nicosia,Europe/Riga,Europe/Samara,Europe/Simferopol,Europe/Sofia,Europe/Tallinn,Europe/Tiraspol,Europe/Uzhgorod,Europe/Vilnius,Europe/Warsaw,Europe/Zaporozhye,Europe/Helsinki,Asia/Gaza,Asia/Hebron,Africa/Cairo,Africa/Tripoli,Asia/Amman,Asia/Beirut,Asia/Damascus,Asia/Gaza,Asia/Hebron,Asia/Istanbul,Asia/Nicosia,Europe/Athens,Europe/Bucharest,Europe/Chisinau,Europe/Istanbul,Europe/Kaliningrad,Europe/Kiev,Europe/Mariehamn,Europe/Minsk,Europe/Moscow,Europe/Nicosia,Europe/Riga,Europe/Simferopol,Europe/Sofia,Europe/Tallinn,Europe/Tiraspol,Europe/Uzhgorod,Europe/Vilnius,Europe/Warsaw,Europe/Zaporozhye,America/Scoresbysund,America/Scoresbysund,America/Santo_Domingo,Chile/EasterIsland,Pacific/Easter,America/New_York,America/Detroit,America/Iqaluit,America/Montreal,America/Nipigon,America/Thunder_Bay,America/Toronto,Canada/Eastern,America/New_York,America/Atikokan,America/Cambridge_Bay,America/Cancun,America/Cayman,America/Chicago,America/Coral_Harbour,America/Detroit,America/Fort_Wayne,America/Grand_Turk,America/Indiana/Indianapolis,America/Indiana/Knox,America/Indiana/Marengo,America/Indiana/Petersburg,America/Indiana/Tell_City,America/Indiana/Vevay,America/Indiana/Vincennes,America/Indiana/Winamac,America/Indianapolis,America/Iqaluit,America/Jamaica,America/Kentucky/Louisville,America/Kentucky/Monticello,America/Knox_IN,America/Louisville,America/Managua,America/Menominee,America/Merida,America/Moncton,America/Montreal,America/Nassau,America/Nipigon,America/Panama,America/Pangnirtung,America/Port-au-Prince,America/Rankin_Inlet,America/Resolute,America/Santo_Domingo,America/Thunder_Bay,America/Toronto,Canada/Eastern,America/New_York,America/Detroit,America/Iqaluit,America/Montreal,America/Nipigon,America/Thunder_Bay,America/Toronto,Canada/Eastern,Europe/Kaliningrad,Europe/Minsk,America/Martinique,Pacific/Fiji,Pacific/Fiji,Atlantic/Stanley,Atlantic/Stanley,Atlantic/Stanley,Atlantic/Stanley,Atlantic/Stanley,Atlantic/Madeira,America/Noronha,Brazil/DeNoronha,America/Noronha,Brazil/DeNoronha,Asia/Aqtau,Asia/Aqtau,Asia/Bishkek,Asia/Bishkek,Asia/Bishkek,Asia/Bishkek,Pacific/Galapagos,Pacific/Gambier,America/Guyana,Asia/Tbilisi,Asia/Tbilisi,Asia/Tbilisi,Asia/Tbilisi,America/Cayenne,America/Cayenne,Africa/Accra,Pacific/Tarawa,Africa/Abidjan,Africa/Accra,Africa/Bamako,Africa/Banjul,Africa/Bissau,Africa/Conakry,Africa/Dakar,Africa/Freetown,Africa/Lome,Africa/Monrovia,Africa/Nouakchott,Africa/Ouagadougou,Africa/Sao_Tome,Africa/Timbuktu,America/Danmarkshavn,Atlantic/Reykjavik,Atlantic/St_Helena,Etc/GMT,Etc/Greenwich,Europe/Belfast,Europe/Dublin,Europe/Gibraltar,Europe/Guernsey,Europe/Isle_of_Man,Europe/Jersey,Europe/London,GB,Asia/Dubai,Atlantic/South_Georgia,Asia/Bahrain,Asia/Muscat,Asia/Qatar,Pacific/Guam,Pacific/Saipan,America/Guyana,America/Guyana,America/Guyana,America/Adak,America/Atka,America/Adak,America/Atka,Pacific/Honolulu,Pacific/Johnston,Asia/Hong_Kong,Asia/Hong_Kong,America/Havana,Atlantic/Azores,Asia/Calcutta,Asia/Dacca,Asia/Dhaka,Asia/Kolkata,Europe/Helsinki,Europe/Mariehamn,Asia/Hovd,Asia/Hovd,Asia/Hovd,Pacific/Honolulu,Pacific/Honolulu,Pacific/Johnston,Pacific/Johnston,Asia/Bangkok,Asia/Ho_Chi_Minh,Asia/Phnom_Penh,Asia/Saigon,Asia/Vientiane,Asia/Jerusalem,Asia/Tel_Aviv,Asia/Jerusalem,Asia/Gaza,Asia/Hebron,Asia/Tel_Aviv,Asia/Ho_Chi_Minh,Asia/Saigon,Asia/Colombo,Asia/Irkutsk,Asia/Istanbul,Europe/Istanbul,Indian/Chagos,Indian/Chagos,Asia/Tehran,Asia/Tehran,Asia/Irkutsk,Asia/Irkutsk,Asia/Irkutsk,Asia/Irkutsk,Asia/Irkutsk,Asia/Chita,Asia/Tehran,Asia/Tehran,Atlantic/Reykjavik,Asia/Jerusalem,Atlantic/Reykjavik,Asia/Calcutta,Asia/Colombo,Asia/Dacca,Asia/Dhaka,Asia/Karachi,Asia/Kathmandu,Asia/Katmandu,Asia/Kolkata,Asia/Thimbu,Asia/Thimphu,Europe/Dublin,Asia/Calcutta,Asia/Colombo,Asia/Karachi,Asia/Kolkata,Europe/Dublin,Europe/Dublin,Asia/Gaza,Asia/Hebron,Asia/Tel_Aviv,Asia/Jakarta,Asia/Pyongyang,Asia/Sakhalin,Asia/Seoul,Asia/Tokyo,ROK,Asia/Tokyo,Asia/Jerusalem,Asia/Tel_Aviv,Asia/Tokyo,Asia/Dili,Asia/Ho_Chi_Minh,Asia/Hong_Kong,Asia/Jakarta,Asia/Kuala_Lumpur,Asia/Kuching,Asia/Makassar,Asia/Manila,Asia/Pontianak,Asia/Pyongyang,Asia/Rangoon,Asia/Saigon,Asia/Sakhalin,Asia/Seoul,Asia/Singapore,Asia/Taipei,Asia/Ujung_Pandang,Pacific/Bougainville,Pacific/Nauru,ROC,ROK,Asia/Taipei,ROC,Asia/Karachi,Asia/Seoul,Asia/Seoul,ROK,ROK,Asia/Bishkek,Asia/Bishkek,Asia/Bishkek,Asia/Qyzylorda,Asia/Qyzylorda,Asia/Qyzylorda,Asia/Qyzylorda,Europe/Vilnius,America/Grand_Turk,America/Jamaica,Europe/Kiev,Pacific/Kosrae,Pacific/Kosrae,Asia/Krasnoyarsk,Asia/Krasnoyarsk,Asia/Novokuznetsk,Asia/Novokuznetsk,Asia/Krasnoyarsk,Asia/Krasnoyarsk,Asia/Krasnoyarsk,Asia/Novokuznetsk,Asia/Novokuznetsk,Asia/Seoul,Asia/Pyongyang,Asia/Seoul,Asia/Pyongyang,ROK,ROK,Europe/Samara,Europe/Samara,Europe/Samara,Pacific/Kwajalein,Australia/LHI,Australia/Lord_Howe,Australia/LHI,Australia/Lord_Howe,Australia/Lord_Howe,Australia/LHI,Pacific/Kiritimati,Pacific/Kiritimati,Pacific/Kiritimati,Asia/Colombo,Asia/Colombo,Africa/Monrovia,Europe/Riga,Atlantic/Madeira,Atlantic/Madeira,Atlantic/Madeira,Asia/Magadan,Asia/Magadan,Asia/Srednekolymsk,Asia/Ust-Nera,Asia/Srednekolymsk,Asia/Ust-Nera,Asia/Magadan,Asia/Magadan,Asia/Magadan,Asia/Srednekolymsk,Asia/Ust-Nera,Asia/Srednekolymsk,Asia/Ust-Nera,Asia/Srednekolymsk,Asia/Ust-Nera,Asia/Singapore,Asia/Kuala_Lumpur,Asia/Singapore,Asia/Singapore,Asia/Singapore,Asia/Kuala_Lumpur,Asia/Kuala_Lumpur,Asia/Kuala_Lumpur,Pacific/Marquesas,Antarctica/Mawson,Antarctica/Mawson,America/Cambridge_Bay,America/Yellowknife,Europe/Moscow,America/Denver,America/Bahia_Banderas,America/Boise,America/Cambridge_Bay,America/Chihuahua,America/Edmonton,America/Hermosillo,America/Inuvik,America/Mazatlan,America/North_Dakota/Beulah,America/North_Dakota/Center,America/North_Dakota/New_Salem,America/Ojinaga,America/Phoenix,America/Regina,America/Shiprock,America/Swift_Current,America/Yellowknife,Canada/East-Saskatchewan,Canada/Mountain,Canada/Saskatchewan,Mexico/BajaSur,Pacific/Kwajalein,Pacific/Kwajalein,Pacific/Majuro,Pacific/Majuro,Antarctica/Macquarie,Europe/Moscow,Europe/Moscow,America/Montevideo,America/Managua,Africa/Monrovia,Indian/Maldives,Asia/Colombo,Asia/Rangoon,Asia/Makassar,Asia/Ujung_Pandang,Europe/Minsk,Asia/Macao,Asia/Macau,Asia/Macao,Asia/Macau,America/Denver,America/Boise,America/Cambridge_Bay,America/Edmonton,America/North_Dakota/Beulah,America/North_Dakota/Center,America/North_Dakota/New_Salem,America/Regina,America/Shiprock,America/Swift_Current,America/Yellowknife,Canada/East-Saskatchewan,Canada/Mountain,Canada/Saskatchewan,Europe/Moscow,Europe/Chisinau,Europe/Kaliningrad,Europe/Kiev,Europe/Minsk,Europe/Riga,Europe/Samara,Europe/Simferopol,Europe/Tallinn,Europe/Tiraspol,Europe/Uzhgorod,Europe/Vilnius,Europe/Volgograd,Europe/Zaporozhye,Europe/Moscow,Europe/Moscow,Europe/Chisinau,Europe/Kaliningrad,Europe/Kiev,Europe/Minsk,Europe/Riga,Europe/Samara,Europe/Simferopol,Europe/Tallinn,Europe/Tiraspol,Europe/Uzhgorod,Europe/Vilnius,Europe/Volgograd,Europe/Zaporozhye,Europe/Simferopol,Europe/Volgograd,Europe/Moscow,America/Denver,America/Bahia_Banderas,America/Boise,America/Cambridge_Bay,America/Chihuahua,America/Creston,America/Dawson_Creek,America/Edmonton,America/Ensenada,America/Hermosillo,America/Inuvik,America/Mazatlan,America/Mexico_City,America/North_Dakota/Beulah,America/North_Dakota/Center,America/North_Dakota/New_Salem,America/Ojinaga,America/Phoenix,America/Regina,America/Santa_Isabel,America/Shiprock,America/Swift_Current,America/Tijuana,America/Yellowknife,Canada/East-Saskatchewan,Canada/Mountain,Canada/Saskatchewan,Mexico/BajaNorte,Mexico/BajaSur,Mexico/General,Europe/Moscow,Indian/Mauritius,Indian/Mauritius,Indian/Maldives,America/Denver,America/Boise,America/Cambridge_Bay,America/Edmonton,America/North_Dakota/Beulah,America/North_Dakota/Center,America/North_Dakota/New_Salem,America/Phoenix,America/Regina,America/Shiprock,America/Swift_Current,America/Yellowknife,Canada/East-Saskatchewan,Canada/Mountain,Canada/Saskatchewan,Asia/Kuala_Lumpur,Asia/Kuching,Pacific/Noumea,Pacific/Noumea,America/St_Johns,Canada/Newfoundland,America/St_Johns,America/St_Johns,America/Goose_Bay,Canada/Newfoundland,America/Goose_Bay,Canada/Newfoundland,America/Paramaribo,Europe/Amsterdam,Europe/Amsterdam,Pacific/Norfolk,Pacific/Norfolk,Asia/Novosibirsk,Asia/Novosibirsk,Asia/Novokuznetsk,Asia/Novosibirsk,Asia/Novosibirsk,Asia/Novokuznetsk,Asia/Novokuznetsk,America/St_Johns,Asia/Katmandu,America/Adak,America/Atka,America/Nome,America/Goose_Bay,Canada/Newfoundland,Asia/Kathmandu,Pacific/Nauru,Pacific/Nauru,America/St_Johns,America/St_Johns,Europe/Amsterdam,America/Goose_Bay,Canada/Newfoundland,America/Goose_Bay,Canada/Newfoundland,America/Adak,America/Atka,America/Nome,Pacific/Midway,Pacific/Pago_Pago,Pacific/Samoa,Pacific/Niue,Pacific/Niue,Pacific/Niue,America/St_Johns,America/Adak,America/Atka,America/Nome,America/Goose_Bay,Canada/Newfoundland,Pacific/Auckland,Antarctica/McMurdo,Antarctica/South_Pole,NZ,Pacific/Auckland,Antarctica/McMurdo,Antarctica/South_Pole,NZ,Pacific/Auckland,Pacific/Auckland,Pacific/Auckland,Antarctica/McMurdo,Antarctica/South_Pole,NZ,Antarctica/McMurdo,Antarctica/South_Pole,NZ,Antarctica/McMurdo,Antarctica/South_Pole,NZ,Asia/Omsk,Asia/Omsk,Asia/Omsk,Asia/Omsk,Asia/Omsk,Asia/Oral,Asia/Oral,Asia/Oral,America/Inuvik,America/Los_Angeles,America/Boise,America/Dawson,America/Dawson_Creek,America/Ensenada,America/Juneau,America/Metlakatla,America/Santa_Isabel,America/Sitka,America/Tijuana,America/Vancouver,America/Whitehorse,Canada/Pacific,Canada/Yukon,Mexico/BajaNorte,America/Lima,Asia/Kamchatka,Asia/Kamchatka,Asia/Kamchatka,Asia/Kamchatka,America/Lima,Pacific/Bougainville,Pacific/Port_Moresby,Pacific/Enderbury,Pacific/Enderbury,Pacific/Enderbury,Asia/Manila,Asia/Manila,Asia/Karachi,Asia/Karachi,Asia/Ho_Chi_Minh,Asia/Saigon,America/Miquelon,America/Miquelon,America/Paramaribo,America/Paramaribo,Antarctica/DumontDUrville,Asia/Yekaterinburg,Asia/Pontianak,Africa/Algiers,Africa/Tunis,Europe/Monaco,Europe/Paris,Pacific/Pitcairn,Pacific/Pohnpei,Pacific/Ponape,America/Port-au-Prince,America/Los_Angeles,America/Dawson_Creek,America/Ensenada,America/Juneau,America/Metlakatla,America/Santa_Isabel,America/Sitka,America/Tijuana,America/Vancouver,Canada/Pacific,Mexico/BajaNorte,America/Los_Angeles,America/Bahia_Banderas,America/Boise,America/Creston,America/Dawson,America/Dawson_Creek,America/Ensenada,America/Hermosillo,America/Inuvik,America/Juneau,America/Mazatlan,America/Metlakatla,America/Santa_Isabel,America/Sitka,America/Tijuana,America/Vancouver,America/Whitehorse,Canada/Pacific,Canada/Yukon,Mexico/BajaNorte,Mexico/BajaSur,Pacific/Pitcairn,America/Los_Angeles,America/Dawson_Creek,America/Ensenada,America/Juneau,America/Metlakatla,America/Santa_Isabel,America/Sitka,America/Tijuana,America/Vancouver,Canada/Pacific,Mexico/BajaNorte,Pacific/Palau,America/Asuncion,America/Asuncion,America/Asuncion,America/Guayaquil,Asia/Qyzylorda,Asia/Qyzylorda,Asia/Qyzylorda,Indian/Reunion,Europe/Riga,Asia/Rangoon,Antarctica/Rothera,Asia/Sakhalin,Asia/Sakhalin,Asia/Sakhalin,Asia/Sakhalin,Asia/Samarkand,Europe/Samara,Europe/Samara,Asia/Samarkand,Asia/Samarkand,Europe/Samara,Europe/Samara,Africa/Johannesburg,Africa/Johannesburg,Africa/Johannesburg,Africa/Maseru,Africa/Mbabane,Africa/Windhoek,Africa/Maseru,Africa/Mbabane,Africa/Maseru,Africa/Mbabane,Africa/Windhoek,Pacific/Guadalcanal,Indian/Mahe,America/Santo_Domingo,Pacific/Apia,Asia/Singapore,Asia/Singapore,Asia/Aqtau,Asia/Aqtau,Asia/Aqtau,America/Costa_Rica,Atlantic/Stanley,America/Santiago,Chile/Continental,Asia/Kuala_Lumpur,Asia/Singapore,Europe/Simferopol,Asia/Srednekolymsk,America/Paramaribo,America/Paramaribo,Pacific/Samoa,Pacific/Apia,Pacific/Midway,Pacific/Pago_Pago,Europe/Volgograd,Europe/Volgograd,Asia/Yekaterinburg,Asia/Yekaterinburg,Asia/Yekaterinburg,Asia/Yekaterinburg,Africa/Windhoek,Antarctica/Syowa,Pacific/Tahiti,Asia/Samarkand,Asia/Tashkent,Asia/Tashkent,Asia/Samarkand,Asia/Tashkent,Asia/Tashkent,Asia/Tbilisi,Asia/Tbilisi,Asia/Tbilisi,Asia/Tbilisi,Asia/Tbilisi,Indian/Kerguelen,Asia/Dushanbe,Pacific/Fakaofo,Pacific/Fakaofo,Asia/Dili,Asia/Dili,Asia/Tehran,Europe/Tallinn,Asia/Ashgabat,Asia/Ashkhabad,Asia/Ashgabat,Asia/Ashkhabad,Pacific/Tongatapu,Pacific/Tongatapu,Pacific/Tongatapu,Europe/Istanbul,Asia/Istanbul,Europe/Istanbul,Asia/Istanbul,Europe/Volgograd,Pacific/Funafuti,Etc/UCT,Asia/Ulaanbaatar,Asia/Ulan_Bator,Asia/Ulaanbaatar,Asia/Ulaanbaatar,Asia/Choibalsan,Asia/Ulan_Bator,Asia/Choibalsan,Asia/Ulan_Bator,Asia/Oral,Asia/Oral,Asia/Oral,Asia/Oral,Asia/Oral,Antarctica/Troll,Etc/Universal,Etc/UTC,Etc/Zulu,UTC,UTC,America/Montevideo,America/Montevideo,America/Montevideo,America/Montevideo,America/Montevideo,Asia/Samarkand,Asia/Tashkent,Asia/Samarkand,Asia/Tashkent,America/Caracas,America/Caracas,Asia/Vladivostok,Asia/Vladivostok,Asia/Khandyga,Asia/Vladivostok,Asia/Vladivostok,Asia/Vladivostok,Asia/Khandyga,Asia/Ust-Nera,Asia/Khandyga,Asia/Ust-Nera,Europe/Volgograd,Europe/Volgograd,Europe/Volgograd,Europe/Volgograd,Antarctica/Vostok,Pacific/Efate,Pacific/Efate,Pacific/Wake,America/Mendoza,America/Argentina/Jujuy,America/Argentina/Mendoza,America/Argentina/San_Luis,America/Jujuy,America/Mendoza,America/Argentina/Catamarca,America/Argentina/ComodRivadavia,America/Argentina/Cordoba,America/Argentina/Jujuy,America/Argentina/La_Rioja,America/Argentina/Mendoza,America/Argentina/Rio_Gallegos,America/Argentina/Salta,America/Argentina/San_Juan,America/Argentina/San_Luis,America/Argentina/Tucuman,America/Argentina/Ushuaia,America/Catamarca,America/Cordoba,America/Jujuy,America/Rosario,Africa/Windhoek,Africa/Ndjamena,Africa/Brazzaville,Africa/Bissau,Africa/El_Aaiun,Africa/Bangui,Africa/Douala,Africa/Kinshasa,Africa/Lagos,Africa/Libreville,Africa/Luanda,Africa/Malabo,Africa/Ndjamena,Africa/Niamey,Africa/Porto-Novo,Africa/Windhoek,Europe/Lisbon,Europe/Madrid,Europe/Monaco,Europe/Paris,Europe/Paris,Europe/Luxembourg,Africa/Algiers,Africa/Casablanca,Africa/Ceuta,Africa/El_Aaiun,Atlantic/Canary,Atlantic/Faeroe,Atlantic/Faroe,Atlantic/Madeira,Europe/Brussels,Europe/Lisbon,Europe/Luxembourg,Europe/Madrid,Europe/Monaco,Europe/Paris,Europe/Luxembourg,Africa/Algiers,Africa/Casablanca,Africa/Ceuta,Africa/El_Aaiun,Atlantic/Azores,Atlantic/Canary,Atlantic/Faeroe,Atlantic/Faroe,Atlantic/Madeira,Europe/Andorra,Europe/Brussels,Europe/Lisbon,Europe/Luxembourg,Europe/Madrid,Europe/Monaco,Pacific/Wallis,America/Godthab,America/Danmarkshavn,America/Godthab,America/Danmarkshavn,Asia/Jakarta,Asia/Pontianak,Asia/Jakarta,Asia/Pontianak,Asia/Jakarta,Asia/Pontianak,Asia/Dili,Asia/Makassar,Asia/Pontianak,Asia/Ujung_Pandang,Asia/Jayapura,Europe/Vilnius,Europe/Warsaw,Pacific/Apia,Pacific/Apia,Pacific/Apia,Asia/Kashgar,Asia/Urumqi,Asia/Yakutsk,Asia/Yakutsk,Asia/Chita,Asia/Khandyga,Asia/Chita,Asia/Khandyga,Asia/Yakutsk,Asia/Yakutsk,Asia/Yakutsk,Asia/Chita,Asia/Khandyga,Asia/Ust-Nera,Asia/Chita,Asia/Khandyga,Asia/Ust-Nera,Asia/Chita,Asia/Khandyga,America/Dawson,America/Whitehorse,Canada/Yukon,America/Dawson,America/Juneau,America/Whitehorse,America/Yakutat,Canada/Yukon,Asia/Yekaterinburg,Asia/Yekaterinburg,Asia/Yekaterinburg,Asia/Yerevan,Asia/Yerevan,Asia/Yerevan,Asia/Yerevan,America/Dawson,America/Whitehorse,America/Yakutat,Canada/Yukon,America/Anchorage,America/Dawson,America/Juneau,America/Nome,America/Sitka,America/Whitehorse,America/Yakutat,Canada/Yukon,America/Dawson,America/Whitehorse,America/Yakutat,Canada/Yukon,Antarctica/Davis,America/Cambridge_Bay,America/Inuvik,America/Iqaluit,America/Pangnirtung,America/Rankin_Inlet,America/Resolute,America/Yellowknife,Antarctica/Casey,Antarctica/DumontDUrville,Antarctica/Macquarie,Antarctica/Mawson,Antarctica/Palmer,Antarctica/Rothera,Antarctica/Syowa,Antarctica/Troll,Antarctica/Vostok,Indian/Kerguelen',
                'class'=>'',
            ],
            [
                'key'=>'general_reminder_hour',
                'type'=>'select',
                'options'=>'0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23',
                'class'=>'',
            ],
            [
                'key'=>'label_certificates',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'menu_show_certificates',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'menu_show_downloads',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'label_downloads',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'general_chat_code',
                'type'=>'textarea',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'menu_show_homework',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'label_courses',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_my_sessions',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_homework',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'regis_confirm_email',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'label_featured',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_calendar',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_blog_posts',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_register',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'info_terms',
                'type'=>'textarea',
                'options'=>'',
                'class'=>'rte',
            ],
            [
                'key'=>'info_privacy',
                'type'=>'textarea',
                'options'=>'',
                'class'=>'rte',
            ],
            [
                'key'=>'general_address',
                'type'=>'textarea',
                'options'=>'',
                'class'=>'rte',
            ],
            [
                'key'=>'general_tel',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'general_contact_email',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'social_enable_facebook',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'social_facebook_secret',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'social_facebook_app_id',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'social_enable_google',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'social_google_secret',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'social_google_id',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'sms_enabled',
                'type'=>'checkbox',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'sms_sender_name',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_sessions_courses',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'label_session_course',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'banner_status',
                'type'=>'radio',
                'options'=>'1=Yes,0=No',
                'class'=>'',
            ],
            [
                'key'=>'banner_app_name',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'banner_android_id',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'banner_ios_id',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'banner_icon_url',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'regis_captcha_type',
                'type'=>'select',
                'options'=>'image=Image,google=Google reCAPTCHA v3',
                'class'=>'',
            ],
            [
                'key'=>'regis_recaptcha_key',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'regis_recaptcha_secret',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],
            [
                'key'=>'config_language',
                'type'=>'text',
                'options'=>'',
                'class'=>'',
            ],

        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
